<?php defined('SYSPATH') or die('No direct script access.');

class Create_serverstats_table extends Migration
{
    public $schema = 'public';
    public $table = 'serverstats';

    public function up()
    {
        if ( 'postgresql' == strtolower(Helper::getCurrentDatabaseConfig('type')) )
        {
            $this->set_schema($this->schema);
        }
        $this->create_table($this->table,
            array(
                'name' => array('string', 'length' => 64, 'null' => false),
                'value' => array('string', 'length' => 4000, 'null' => false),
                'title' => array('string', 'length' => 255, 'null' => false),
                'order' => array('integer', 'unsigned' => true, 'null' => false),
                'updated_at' => array('timestamp'),
            ),
            'name'
        );
        $this->add_index($this->table, 'serverstats_name_pkey', array('name'), 'primary');
        $this->add_index($this->table, 'serverstats_order_idx', array('order'), 'normal');
    }

    public function down()
    {
        if ( 'postgresql' == strtolower(Helper::getCurrentDatabaseConfig('type')) )
        {
            $this->set_schema($this->schema);
        }
        $this->drop_table($this->table);
    }
}